<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ReportWarehouse2TotalModels extends CI_Model
{
    /*
    `SELECT  tienda.NombreT AS Tienda, clasificacion.Nombre AS Area,producto.CodigoP AS Codigo, producto.Nombre AS Producto ,producto.Marca AS Marca, producto.Modelo AS Modelo,movimientop.Existencia AS Stock, proveedor.Nombres AS Proveedor, proveedor.Telefono AS Telefono,  movimientop.charge as Encargo,  detallemov.Costo As Costo, detallemov.Cantidad As Ultima_Compra, detallemov.CodigoD AS Detalle,  movimientop.StopMinimo AS Minimo, movimientop.StopMax AS Max FROM tienda 
    LEFT JOIN movimientop ON movimientop.CodigoT = tienda.Codigo
    LEFT JOIN producto ON movimientop.CodigoP = producto.CodigoP 
    LEFT JOIN clasificacion On clasificacion.ID = producto.Clasificacion 
    LEFT JOIN detallemov ON movimientop.CodigoM  = detallemov.CodigoMo  and detallemov.CodigoD = ( SELECT detallemov.CodigoD FROM detallemov WHERE(detallemov.CodigoMo =movimientop.CodigoM )  ORDER BY detallemov.CodigoD DESC LIMIT 1 )
    LEFT JOIN proveedor ON detallemov.CodigoProve  = proveedor.CodigoProve  
    WHERE  ( producto.Status = 'Activo' )  ORDER BY movimientop.Existencia ASC`
    */
    private $Tabla = "tienda";
    private $Delimitador= "|";
    private $Separador = "^";
    private $CamposTablas = ["'TOTAL'","producto.CodigoP","clasificacion.Nombre","tienda.NombreT","producto.Nombre","producto.Marca","producto.Modelo","SUM(movimientop.Existencia)","proveedor.Nombres","producto.Descripcion","proveedor.Telefono", "SUM(detallemov.Costo)", "SUM(detallemov.Cantidad)","SUM(detallemov.CantidadActual)","detallemov.Vencimiento", "detallemov.CodigoD", "SUM(movimientop.StopMinimo)", "SUM(movimientop.StopMax)","proveedor.CodigoProve","SUM(movimientop.CostoD)","detallemov.Fecha","detallemov.CodigoAux","SUM(((((movimientop.CostoD/(1+ (movimientop.iva/100))/ (1 + (movimientop.ILA/100)))) - (detallemov.Costo  ))/(((movimientop.CostoD/(1+ (movimientop.iva/100))/ (1 + (movimientop.ILA/100))))) *100))","SUM(movimientop.Existencia * movimientop.CostoD)", "SUM(movimientop.Existencia * detallemov.Costo)" ];
    private $CamposTablas2 = ["'TOTAL'","producto.CodigoP","clasificacion.Nombre","tienda.NombreT","producto.Nombre","producto.Marca","producto.Modelo","movimientop.Existencia","proveedor.Nombres","producto.Descripcion","proveedor.Telefono", "detallemov.Costo", "detallemov.Cantidad","detallemov.CantidadActual","detallemov.Vencimiento", "detallemov.CodigoD", "movimientop.StopMinimo", "movimientop.StopMax","proveedor.CodigoProve","movimientop.CostoD","detallemov.Fecha","detallemov.CodigoAux","((((movimientop.CostoD/(1+ (movimientop.iva/100))/ (1 + (movimientop.ILA/100)))) - (detallemov.Costo  ))/(((movimientop.CostoD/(1+ (movimientop.iva/100))/ (1 + (movimientop.ILA/100))))) *100)","movimientop.Existencia * movimientop.CostoD", "movimientop.Existencia * detallemov.Costo" ];

    private function InitJoin(){
        $this->db->join("movimientop"," movimientop.CodigoT = tienda.Codigo","LEFT",false);
        $this->db->join("producto","movimientop.CodigoP = producto.CodigoP","LEFT",false);
        $this->db->join("clasificacion","clasificacion.ID = producto.Clasificacion","LEFT",false);
        $this->db->join("detallemov","movimientop.CodigoM  = detallemov.CodigoMo  and detallemov.CodigoD = ( SELECT detallemov.CodigoD FROM detallemov WHERE(detallemov.CodigoMo =movimientop.CodigoM AND detallemov.Status =  'Entrada' )  ORDER BY detallemov.CodigoD DESC LIMIT 1 )","LEFT",false);
        $this->db->join("proveedor","detallemov.CodigoProve  = proveedor.CodigoProve","LEFT",false);
        $this->db->where('producto.Status',$this->db->escape("Activo"),false);
        $this->db->where('movimientop.Status',$this->db->escape("Activo"),false);
       }
    private function ValidarCdProducto($CD){
        $Res=  $this->db->get_where("producto",array("CodigoP"=>$CD))->result();
        if (count($Res) ===0){
            return $CD;
        }
        if ($Res[0]->Status === "Auxiliar"){
            return $Res[0]->CodigoAux;
        }
        return $CD;

    }
 



    private function Filtros($Filtros){
        $Filtros= str_replace('ø','/',$Filtros);
        $arr1 = explode($this->Delimitador,$Filtros);
        $array_num = count($arr1);
  
        for ($i = 0; $i < $array_num; ++$i){
           
            $posicion_coincidencia = strpos($arr1[$i], $this->Separador);
            if(  $posicion_coincidencia != FALSE ){
              $Array2 = explode($this->Separador,$arr1[$i]);
              $Array2[0]= $this->columna($Array2[0]);
              if($Array2[0]==="producto.CodigoP")
              {
                $Array2[1]= $this->db->escape($this->ValidarCdProducto($Array2[1]));
              }else{
                
               
                $Array2[1]= $this->db->escape($Array2[1]); 
              }
              $arr1[$i] =  $Array2;
              $posicion_coincidencia = strpos( $Array2[1], ',');

              if($posicion_coincidencia === false ){
               
              }else{
             
                 
                $Fechas =  explode(',',$Array2[1]);

                if(count($Fechas) ===2){
                    $this->db->where($Array2[0]." BETWEEN ".$Fechas[0]."' AND '".$Fechas[1]."", NULL, FALSE );
                    
                    unset($arr1[$i]);
                }
                
              }
              

             
            }else {
                $arr1[$i]= array("Todo", $arr1[$i]);
            }
        }
        $arr1 = array_values($arr1);
        return  $arr1;
    }

   
    private  function columna($id = null,$Mascara = false){
        $fields = $this->CamposTablas;
        if($id === null){
          
            $array_num = count($fields);
            for ($i = 0; $i < $array_num; ++$i){
                $fields[$i] =  $fields[$i]. " AS ". $this->Mascara($fields[$i]);
            }
            return $fields;

        }

        if(is_numeric($id)===false){
            $array_num = count($fields);
            for ($i = 0; $i < $array_num; ++$i){
                if($id === $fields[$i] ||  $this->Mascara($fields[$i]) === $id ){
                    if($Mascara=== false){
                        return $fields[$i];
                    }else{
                        return $fields[$i]. " AS ". $this->Mascara($fields[$i]);
                    }
                  
                }
              
            }
            return $fields[0];
        }else{

       

        if($Mascara === false){
            if(intval($id) < count($fields) && intval($id) > 0 ){
                return  $fields[intval($id)];
              }else{
                return $fields[0];
              }
        }else{
            if(intval($id) < count($fields) && intval($id) > 0 ){
                return  $fields[intval($id)]. " AS ". $this->Mascara($fields[intval($id)]);
              }else{
                return $fields[0]. " AS ". $this->Mascara($fields[0]);
              }        
        }
    }
       
    }
    private function Columnas($col = null,$Mascara = false){
          if($col=== null){
           $Arra =  $this->columna(null);
           return $Arra;
          }

        $Colu = substr($col, 1);
        $posicion_coincidencia = strpos($Colu, $this->Delimitador);
        if(  $posicion_coincidencia === FALSE ){
            $arr1 = str_split($Colu);
        }else{
            $arr1 = explode($this->Delimitador,$Colu);
        }
     
        $array_num = count($arr1);
        for ($i = 0; $i < $array_num; ++$i){
            $arr1[$i] =  $this->columna($arr1[$i],$Mascara);
        }
        return $arr1;
    }
    public function getReportWarehouse2Total($id=NULL)
    {
       
       if ($id === NULL){
        $this->db->distinct()->select($this->Columnas(),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla)->result();
     
       }else{
          
           $Columna = $this->columna(0);
           $this->db->distinct()->select($this->Columnas(),false);
           $this->InitJoin();
           $this->db->where($this->Tabla.'.CodigoM',$this->db->escape("$id"),false);
           return  $this->db->get($this->Tabla)->result();

       }
       
    }
    public function getReportWarehouse2TotalLimite($Canti,$Desde){
        $this->db->distinct()->select($this->Columnas(),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReportWarehouse2TotalLimiteOrden($Canti,$Desde,$Columna,$Orden){
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
     
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        $this->db->distinct()->select($this->Columnas(),false);
        $this->InitJoin();
        $this->db->order_by($this->columna($Columna), $Direccion);
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReportWarehouse2TotalLimiteOrdenColumnas($Canti,$Desde,$Columna,$Orden,$Columnas){
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);
        $this->InitJoin();
        $this->db->order_by($this->columna($Columna), $Direccion);
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReportWarehouse2TotalIdColum($id,$Columnas){
       
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);
        $Columna = $this->columna(0);
        $this->InitJoin();
        $this->db->where($Columna,$this->db->escape("$id"),false);
        return  $this->db->get($this->Tabla)->result();
    }
    public function getReportWarehouse2TotalLimiteColum($Canti,$Desde,$Columnas){
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReportWarehouse2TotalFiltro($Filtros){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas2;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
      
        $this->db->distinct()->select($this->Columnas(),false);
     return  $this->db->get($this->Tabla)->result();
      
    }
    private function total(){
        $this->db->distinct()->select("count(*) As Total",false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla)->result();
    }
    public function getReportWarehouse2TotalFiltroLimite($Filtros,$Canti,$Desde){
      
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas2;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $this->db->distinct()->select($this->Columnas(),false);
     return   $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getReportWarehouse2TotalFiltroLimiteOrden($Filtros,$Canti,$Desde,$Columna,$Orden){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas2;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
        $this->db->distinct()->select($this->Columnas(),false);
     $this->db->order_by($this->columna($Columna), $Direccion);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getReportWarehouse2TotalFiltroLimiteOrdenColumnas($Filtros,$Canti,$Desde,$Columna,$Orden,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas2;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
     $this->db->distinct()->select($this->Columnas($Columnas,true),false);
     $this->db->order_by($this->columna($Columna), $Direccion);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getReportWarehouse2TotalFiltroColumnas($Filtros,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas2;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);

     return  $this->db->get($this->Tabla)->result();
      
    }

    public function getReportWarehouse2TotalFiltroLimitesColumnas($Filtros,$Canti,$Desde,$Columnas){
      
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
    
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas2;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status =',"'Activo')",false ); 
        }
        $this->db->distinct()->select($this->Columnas($Columnas,true),false);

     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
   
// desde aqui comianza la configuracion

    private function Mascara($Clave= null){
$ArrayReportWarehouse2Total["'TOTAL'"]= utf8_encode("Código");
$ArrayReportWarehouse2Total["tienda.NombreT"]= "Tienda";
$ArrayReportWarehouse2Total["clasificacion.Nombre"]=  utf8_encode('Área');
$ArrayReportWarehouse2Total["producto.CodigoP"]= utf8_encode("Producto");
$ArrayReportWarehouse2Total["producto.Nombre"]="Nombre";
$ArrayReportWarehouse2Total["producto.Marca"]= 'Marca';
$ArrayReportWarehouse2Total["producto.Modelo"]= 'Modelo';
$ArrayReportWarehouse2Total["producto.Descripcion"]=utf8_encode('Descripción');
$ArrayReportWarehouse2Total["SUM(movimientop.Existencia)"]="Stock" ;
$ArrayReportWarehouse2Total["proveedor.Nombres"]= "Proveedor";
$ArrayReportWarehouse2Total["proveedor.Telefono"]= utf8_encode('Teléfono');
$ArrayReportWarehouse2Total["SUM(detallemov.Costo)"]= "Costo";
$ArrayReportWarehouse2Total["SUM(detallemov.Cantidad)"]= "IngresoLote";
$ArrayReportWarehouse2Total["SUM(detallemov.CantidadActual)"]= "StockLote";
$ArrayReportWarehouse2Total["detallemov.Vencimiento"]= "Vencimiento";
$ArrayReportWarehouse2Total["detallemov.CodigoD"]= "Lote";
$ArrayReportWarehouse2Total["SUM(movimientop.StopMinimo)"]= "MIN";
$ArrayReportWarehouse2Total["SUM(movimientop.StopMax)"]= utf8_encode('MAX');
$ArrayReportWarehouse2Total["proveedor.CodigoProve"]= "CodigoProve";
$ArrayReportWarehouse2Total["SUM(movimientop.CostoD)"]= "Precio";
$ArrayReportWarehouse2Total["detallemov.Fecha"]= "Fecha";
$ArrayReportWarehouse2Total["detallemov.CodigoAux"]= "CodigoAux";
$ArrayReportWarehouse2Total["SUM(((((movimientop.CostoD/(1+ (movimientop.iva/100))/ (1 + (movimientop.ILA/100)))) - (detallemov.Costo  ))/(((movimientop.CostoD/(1+ (movimientop.iva/100))/ (1 + (movimientop.ILA/100))))) *100))"] = "Rentabilidad";
$ArrayReportWarehouse2Total["SUM(movimientop.Existencia * movimientop.CostoD)"]= "TotalPrecio";
$ArrayReportWarehouse2Total["SUM(movimientop.Existencia * detallemov.Costo)"] = "TotalCosto";


if($Clave === null){
    $array = array();
    foreach($ArrayReportWarehouse2Total as $key => $val) {
        $array[$val]= array_search(array_search($val,$ArrayReportWarehouse2Total),$this->CamposTablas)
       ;
    }
    
   
    return $array;
}       


if (isset($ArrayReportWarehouse2Total[$Clave])){
return $ArrayReportWarehouse2Total[$Clave];
}else{
return $Clave;
}
}

    private function verificarExistencia($dato,$Array)
    {
        $array_num = count($Array);
        for ($id = 0; $id < $array_num; ++$id){
            if($Array[$id]["nombre"] == $dato){
              return $id;
            }
        }
        return false;
    }






   Public function MetaData($Mascara = true){

    $meta3['Producto'] = [
        "name"=> 'Producto',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Product',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'s02',
        "necessary"=> true, 
        "modified"=> false, 
        "type"=>'text', 
    ];
    $meta3['Área'] = [
        "name"=> 'Área',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Classification',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'Clasificación',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'text', 
    ];
    $meta3['Lote'] = [
        "name"=> 'Lote',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'ReporWareDetalle',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'s11',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'text', 
    ];
    $meta3['Tienda'] = [
        "name"=> 'Tienda',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Store',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'Tienda',
        "necessary"=> true, 
        "modified"=> false, 
        "type"=>'text',  
    ];
    $meta3['Fecha'] = [
        "name"=> 'Fecha',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'date', 
    ];
    $meta3['Vencimiento'] = [
        "name"=> 'Vencimiento',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'date', 
    ];
    $meta3['Proveedor'] = [
        "name"=> 'Proveedor',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Provider',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'Nombre',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'text', 
    ];
/*
    $meta3['Region'] = [
        "name"=> 'Región',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'',
        "option"=> [""=>"",
        "1"=>"Región de Arica y Parinacota",
        "2"=>"Región de Tarapacá",
        "3"=>"Región de Antofagasta",
        "4"=>"Región de Atacama",
        "5"=>"Región de Coquimbo", 
        "6"=>"Región de Valparaíso",
        "7"=>"Región del Libertador General Bernardo O'Higgins",
        "8"=>"Región del Maule",
        "9"=>"Región del Biobío",
        "10"=>"Región de La Araucanía",
        "11"=>"Región de Los Ríos",
        "12"=>"Región de Los Lagos",
        "13"=>"Región Aysén del General Carlos Ibáñez del Campo",
        "14"=>"Región de Magallanes y de la Antártica Chilena",
        "27"=>"Región de Ñuble",
        ],
        "filter"=>'',
        "Datos"=>'',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'text', 
    ];
    $meta3['Comuna'] = [
        "name"=> 'Comuna',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'',
        "option"=> [""=>""],
        "filter"=>'',
        "Datos"=>'',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'text', 
    ];
    $meta3['Ciudad'] = [
        "name"=> 'Ciudad',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'',
        "option"=> [""=>""],
        "filter"=>'',
        "Datos"=>'',
        "necessary"=> true, 
        "modified"=> false,  
        "type"=>'text', 
    ];
*/
 
   $T =  $this->total();
    $obj = new stdClass();
    $obj->Total  = $T[0]->Total;
    $obj->Campos= $this->Mascara();
    $obj->Select= $meta3;
return $obj;

} 

}
