<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ProviderCtrl extends MY_Controller {
  public function __construct($config = 'rest')
  {
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Authorization, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
    header("Allow: GET, POST, OPTIONS, PUT, DELETE");
    header('content-type: application/json; charset=utf-8');
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
        die();
    }
      parent::__construct();
      $this->load->library('Pdf');
  }

  public function _remap($met,$parametros = array()){
   
  $method = $_SERVER['REQUEST_METHOD'];

 switch ($met)  
 { case 'Buscar1':
     $this->Buscar1($parametros); 
     break;
   case 'Buscar2': 
     $this->Buscar2($parametros);   
   break;
   case 'Buscar3': 
     $this->Buscar3($parametros); 
   break; 
   case 'Buscar4': 
    $this->Buscar4($parametros);
   break; 
   case 'Buscar5': 
    $this->Buscar5($parametros);
   break; 
   case "MetaData":
    $this->MetaData($parametros);
   break;
   case "Pdf":
    $this->Pdf();
    break;

 }
 if($met ==="index"){

  switch ($method)  
  { case 'PUT':
      $this->Edit(); 
    break;
    case 'POST': 
      $this->Add();
    break;
    case 'GET': 
      $this->Search($parametros);
 break;
    case 'HEAD': 
      // echo json_encode( $method );
    break; 
    case 'DELETE': 
      $this->Delete($parametros); 
    break; 
    case 'OPTIONS': 
     // echo json_encode( $method );
   break; 
   default: 
   echo json_encode( "Error" );
   break; 
  }
}


 }
private function Add(){
  $Datos = count($_POST) ===0 ? $this->input->raw_input_stream :  $this->input->post();
  if(is_string($Datos) ===true){
    $Datos =  json_decode($Datos, true);
  }

    $Proveedor= $this->ProviderModels->Add($Datos);

  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Proveedor);
}
     
private function Edit(){
  $Datos = $this->input->raw_input_stream;
  if(is_string($Datos) ===true){
    $Datos =  json_decode($Datos, true);
  }
  $Proveedor= $this->ProviderModels->Edit($Datos);
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Proveedor);
    
}

private function Delete($ID ){
  $Proveedor= $this->ProviderModels->Delete($ID[0]);
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Proveedor);
}

// aqui viene los metodos de buscar



private function Search($Arr =array() ){
  $Proveedor =array();
  switch (count($Arr)) 
  { case 0:
    $Proveedor= $this->ProviderModels->getProvider();
    break;
    case 1: 
      $Proveedor = $this->ProviderModels->getProvider($Arr[0]);
    break;
    case 2: 
      $Proveedor = $this->ProviderModels->getProviderLimite($Arr[0],$Arr[1]);
    break; 
    case 4: 
      $Proveedor = $this->ProviderModels->getProviderLimiteOrden($Arr[0],$Arr[1],$Arr[2],$Arr[3]);
    break; 
    case 5: 
      $Proveedor = $this->ProviderModels->getProviderLimiteOrdenColumnas($Arr[0],$Arr[1],$Arr[2],$Arr[3],urldecode($Arr[4]));
   break; 
   default: 
   echo json_encode( "Error" );
   break; 
  }
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Proveedor); 
}

private function Buscar1 ($Arr = array()){
  $Proveedor =array();
  switch (count($Arr)) 
  {
    case 1: 
      $Proveedor = $this->ProviderModels->getProviderFiltro(urldecode($Arr[0]));
    break;
    case 3: 
      $Proveedor = $this->ProviderModels->getProviderFiltroLimite(urldecode($Arr[0]),$Arr[1],$Arr[2]);
    break; 
    case 5: 
      $Proveedor = $this->ProviderModels->getProviderFiltroLimiteOrden(urldecode($Arr[0]),$Arr[1],$Arr[2],$Arr[3],$Arr[4]);
   break; 
   case 6: 
    $Proveedor = $this->ProviderModels->getProviderFiltroLimiteOrdenColumnas(urldecode($Arr[0]),$Arr[1],$Arr[2],$Arr[3],$Arr[4],urldecode($Arr[5]));
    break; 
   default: 
   echo json_encode( $Arr );
   break; 
  }
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Proveedor); 
  
}
private function Buscar2 ($Arr =array()){
  $Proveedor =array();
  $Proveedor = $this->ProviderModels->getProviderFiltroColumnas(urldecode($Arr[0]),urldecode($Arr[1]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Proveedor); 
}

private function Buscar3 ($Arr =array()){
  $Proveedor =array();
    $Proveedor= $this->ProviderModels->  getProviderIdColum($Arr[0],urldecode($Arr[1]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Proveedor); 
}
private function Buscar4 ($Arr = array()){
  $Proveedor =array();
    $Proveedor= $this->ProviderModels->getProviderLimiteColum($Arr[0],$Arr[1],urldecode($Arr[2]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Proveedor); 
}
private function Buscar5 ($Arr =  array()){
  $Proveedor =array();
  $Proveedor = $this->ProviderModels->getProviderFiltroLimitesColumnas(urldecode($Arr[0]),$Arr[1],$Arr[2],urldecode($Arr[3]));
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Proveedor); 

}
private function Pdf(){

  $Proveedor= $this->ProviderModels->getProvider();
  $Proveedor = str_replace('C\u00c3\u00b3digo','Codigo',json_encode($Proveedor));
  $Proveedor = str_replace('Tel\u00c3\u00a9fono','Telefono',$Proveedor);
  $Proveedor = str_replace('Direcci\u00f3n','Direccion',$Proveedor);
  $Proveedor= json_decode($Proveedor);
 $bodyproveedor= $this->BodyTabla($Proveedor,array('Codigo','Rut',"Nombre","Apellido",'Telefono','Direccion',"Email"));
 //echo json_encode($Clientes);
// return;
  $tcpdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
  $tcpdf->SetAuthor('segmarind');
  $tcpdf->SetTitle('Reporte de Proveedor');
  $tcpdf->SetSubject('segmarind');
  $tcpdf->SetKeywords('TCPDF, PDF, segmarind, test, guide');
  $tcpdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "", "", array(0,65,256), array(0,65,127));
  $tcpdf->setFooterData(array(0,65,0), array(0,65,127));
  $tcpdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
  $tcpdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
  $tcpdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
  $tcpdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
  $tcpdf->SetHeaderMargin(PDF_MARGIN_HEADER);
  $tcpdf->SetFooterMargin(PDF_MARGIN_FOOTER);
  $tcpdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
  $tcpdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
if (@file_exists(dirname(__FILE__).'/lang/eng.php'))
{
// optional
require_once(dirname(__FILE__).'/lang/eng.php');
// optional
$tcpdf->setLanguageArray($l);
}
 
$tcpdf->setFontSubsetting(true);
$tcpdf->AddPage();
$set_html = <<<EOD
 
 

<h3  style="text-align: center;">Reporte De Proveedor</h3>

<br/>

<br>
<br/>
<br/>

<br>
<br>



<table   border="1" >

<tr>
<th ><FONT SIZE="8"><b> Código</b></FONT></th>
<th ><FONT SIZE="8"><b> Rut</b></FONT></th>
<th ><FONT SIZE="8"><b> Nombres</b></FONT></th>
<th ><FONT SIZE="8"><b> Apellidos </b></FONT></th>
<th ><FONT SIZE="8"><b> Teléfono</b></FONT></th>
<th ><FONT SIZE="8"><b> Dirección</b></FONT></th>
<th ><FONT SIZE="8"><b> Correo</b></FONT></th>
</tr>
$bodyproveedor
</table> 
EOD;
$tcpdf->writeHTMLCell(0, 0, '', '', $set_html, 0, 1, 0, true, '', true);
$tcpdf->Output('tcpdfexample-onlinecode.pdf', 'I');
  return;
}


function BodyTabla($arr,$Titulos){
 
  $Fi = "";
  foreach ($arr as $Fila){
    $Fi=  $Fi.'<tr>';
    $Colum= '';
 
    
         for( $i=0; $i< count($Titulos); $i++  ){
          foreach (  $Fila as $key => $val){
          if( $Titulos[$i] ===$key){
            $Colum =  $Colum. '<td ><FONT SIZE="8"> '. utf8_decode($val).' </FONT></td>';
          }
        }
        }
    
    $Fi= $Fi.$Colum.'</tr>';
  }
return $Fi;
}

private function MetaData(){
  $Proveedor =array();
  $Proveedor = $this->ProviderModels->MetaData();
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Proveedor); 
}

    protected function middleware()
    {
      return ['Sesion','Permisos'];
    }

	
}