<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PedidosCtrl extends MY_Controller {

  public function __construct($config = 'rest')
  {
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Authorization, Access-Control-Request-Method");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
    header("Allow: GET, POST, OPTIONS, PUT, DELETE");
    header('content-type: application/json; charset=utf-8');
    $method = $_SERVER['REQUEST_METHOD'];
    if($method == "OPTIONS") {
        die();
    }
      parent::__construct();
      $this->load->library('Pdf');
  }
  public function _remap($met,$parametros = array()){

  $method = $_SERVER['REQUEST_METHOD'];
  $res = "";
 switch ($met)  
 { case 'Buscar1':
    $res =   $this->Actualizar($this->Buscar1($parametros)); 
    echo ($res);
     break;
   case 'Buscar2': 
    $res =   $this->Actualizar($this->Buscar2($parametros));
    echo ($res);   
   break;
   case 'Buscar3': 
    $res =   $this->Actualizar($this->Buscar3($parametros));
    echo ($res); 
   break; 
   case 'Buscar4': 
    $res =   $this->Actualizar($this->Buscar4($parametros));
    echo ($res);
   break; 
   case 'Buscar5': 
    $res =   $this->Actualizar($this->Buscar5($parametros));
    echo ($res);
   break; 
   case "MetaData":
    $res =   $this->Actualizar($this->MetaData($parametros));
    echo ($res);
   break;
   case "Pdf":
   $this->Pdf();
    break;

 }
 if($met ==="index"){

  switch ($method)  
  { case 'PUT':
      $this->Edit(); 
    break;
    case 'POST': 
      $this->Add();
    break;
    case 'GET': 
    
      $res =    $this->Actualizar($this->Search($parametros));
      echo ($res);
    case 'HEAD': 
      // echo json_encode( $method );
    break; 
    case 'DELETE': 
      $this->Delete($parametros); 
    break; 
    case 'OPTIONS': 
     // echo json_encode( $method );
   break; 
   default: 
   echo json_encode( "Error" );
   break; 
  }
}


 }

 private function Actualizar($String){
  $Array = json_decode($String, true);
  if(count($Array) === 1){
    
    
    $datos = $Array[0]["Detalle"];
    $datos = json_decode($datos, true);
    foreach ($datos["Articulos"] as $key => $val){
      $Warehousees = $this->AssignmentModels->getAssignmentFiltroColumnas("s0^".$datos["Articulos"][$key]["Código"],"s0|8");

      $datos["Articulos"][$key]["Stock"] =  $Warehousees[0]->Existencia;
      
    }
  
    $Array[0]["Detalle"] = json_encode( $datos );
    return json_encode( $Array );
  }else{
    return $String;
  }

 }
 private function CrearpdfPedido($Obj){
  $DatosTienda  = $this->StoreModels->getStore($Obj['Select']['Tienda']['value']);
  $DatosTienda =$DatosTienda[0];
  $Codigo = $Obj['Codigo'];
  $DatosProveedor  = $this->ProviderModels->getProvider($Obj['Text']['Proveedor']['value2']);
  $DatosProveedor = $DatosProveedor[0];
  $Email =   $DatosProveedor->Email;
  if ( $Email === ""){
    return;
  }
  $Proveedor =  $DatosProveedor->Nombre. ' '.$DatosProveedor->Apellido;

  $Token = obtnerToken();
  $Autho = "";
 if($Token != FALSE){
  $Autho =str_replace('Bearer ','', $Token);
 }
 if( $Autho !=""){
  $Autho =str_replace('Bearer ','', $Autho);
  $Token = ValidarToken($Autho);
}
  if(isset($this->session)){
    $ID =  $Token== FALSE ? $this->session->userdata("User") :  $Token ;
}else{
    $ID =   $Token== FALSE ? null :  $Token ;
}
  $User = $this->UserModels->getUser($ID);
  $User=  $User[0];
  $Dire = utf8_encode('Dirección'); 
  $Tele = utf8_encode('Teléfono');
  $Empresa = $DatosTienda->Tienda;
  $Fecha =  date("Y-m-d H:i:s");
  $Cliente = $DatosTienda->Tienda;
  $Direccion =$DatosTienda->$Dire;
  $Telefono = $DatosTienda->$Tele." / " . $User->$Tele;
  $NombreDeContacto = $User->Nombre ." ".  $User->Apellido ;
  $Correo =  $DatosTienda->Correo ." / ".$User->Correo;
  $ArrayProduc = array('Producto','Nombre','Unidades','Cantidad');
  foreach (  $Obj["Articulos"] as $key => $val){
    if($Obj["Articulos"][$key]['Unidades'] === 0){
      $Obj["Articulos"][$key]['Unidades'] = "Unidad";
    }

    $Obj["Articulos"][$key]["Nombre"]= $Obj["Articulos"][$key]["Nombre"].' '. $Obj["Articulos"][$key]["Marca"]. ' '.$Obj["Articulos"][$key]["Modelo"];
  }
  
  $BodyProduc =  $this->BodyTabla($Obj["Articulos"], $ArrayProduc); 
  $tcpdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

$tcpdf->SetAuthor('segmarind');
$tcpdf->SetTitle('Solicitud al Proveedor');
$tcpdf->SetSubject('segmarind');
$tcpdf->SetKeywords('TCPDF, PDF, segmarind, test, guide');
$tcpdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "", "", array(0,65,256), array(0,65,127));


$tcpdf->setFooterData(array(0,65,0), array(0,65,127));
 
//set header  textual styles
$tcpdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
//set footer textual styles
$tcpdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
//set default monospaced textual style
$tcpdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
// set default margins
$tcpdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
// Set Header Margin
$tcpdf->SetHeaderMargin(PDF_MARGIN_HEADER);
// Set Footer Margin
$tcpdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
// set auto for page breaks
$tcpdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image for scale factor
$tcpdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// it is optional :: set some language-dependent strings
if (@file_exists(dirname(__FILE__).'/lang/eng.php'))
{
// optional
require_once(dirname(__FILE__).'/lang/eng.php');
// optional
$tcpdf->setLanguageArray($l);
}
 
// set default font for subsetting mode
$tcpdf->setFontSubsetting(true);



// Set textual style
// dejavusans is an UTF-8 Unicode textual style, on the off chance that you just need to
// print standard ASCII roasts, you can utilize center text styles like
// helvetica or times to lessen record estimate.
//$tcpdf->SetFont('dejavusans', '', 14, '', true);
 
// Add a new page
// This technique has a few choices, check the source code documentation for more data.
$tcpdf->AddPage();




$set_html = <<<EOD
 
 
<h3  style="text-align: center; text-decoration: underline;">PEDIDO DE PRODUCTOS</h3>
<h5  style="text-align: center;">$Empresa </h5>


<br/>
<br/>
<br/>
<br/> 
<div > Nro : $Codigo </div>
<div > Fecha : $Fecha </div>

<div><FONT SIZE="9"  style="text-align: left; display: block;"><b>Datos del solicitante:</b></FONT></div>
<span><FONT SIZE="9"  style="text-align: left; display: block;"><b>Cliente:</b></FONT> $Cliente</span>
<br/>
<span><FONT SIZE="9"  style="text-align: left;"><b>Dirección:</b></FONT> $Direccion</span>
<br/>
<span><FONT SIZE="9"  style="text-align: left;"><b>Teléfono:</b></FONT> $Telefono</span>
<br/>
<span><FONT SIZE="9"  style="text-align: left;"><b>Nombre del contacto:</b></FONT> $NombreDeContacto</span>
<br/>
<span><FONT SIZE="9"  style="text-align: left;"><b>Correo electrónico:</b></FONT> $Correo</span>
<br/>
<div>
<FONT SIZE="9"  > Estimados Señores:  $Proveedor</FONT>
<br/> 
<FONT SIZE="9"  style="text-align: justify;">
Me dirijo a Ustedes con el debido respeto que merece su persona, y expongo que deseo realizar un pedido formado por los siguientes productos:</FONT>
</div>

<hr>
<h4  style="text-align: center; ">DESCRIPCIÓN DE PRODUCTOS</h4>
<br/>
<table   border="1" >
<tr>
<th ><FONT SIZE="8"><b>ID</b></FONT></th>
<th ><FONT SIZE="8"><b>Producto</b></FONT></th>
<th ><FONT SIZE="8"><b>Unidades</b></FONT></th>
<th ><FONT SIZE="8"><b>Cantidad</b></FONT></th>
</tr>

$BodyProduc


</table>
<br/>
<br/>


 

<FONT SIZE="9"  style="text-align: justify;">
En caso de no contar con algunos de los artículos o referencias, les rogamos que nos lo comuniquen, y así poder contemplar la posibilidad de sustituirlo por otro similar, antes del envío del pedido</FONT>
<br/>
<br/>
<br/> 
<FONT SIZE="9"  >Sin otro particular, reciban un cordial saludo </FONT>
 
EOD;

//Print content utilizing writeHTMLCell()
$Dir = Raiz();
$tcpdf->writeHTMLCell(0, 0, '', '', $set_html, 0, 1, 0, true, '', true);
if (Existe($Dir.'/Cotizaciones/') === false){
  CrearCarpeta($Dir.'/Cotizaciones/');
 
 }
 $tcpdf->Output($Dir.'/Cotizaciones/'."Pedido".'.pdf', 'F');
 if($Email != ""){
  $htmlContent = '<h1>Solicitud de Pedido</h1>';
 
  EmailHtml($Email,$Empresa, $htmlContent,$Dir.'/Cotizaciones/'."Pedido".'.pdf');

 }

 //$tcpdf->Output('Solicitud.pdf', 'I');
 /*
 switch (count($parametros)) { 
  
  case 0:
    break;
  case 1:
    $tcpdf->Output('Certificado.pdf', 'I');
  break;
  case 2:
  
   if (Existe($Dir.'/CertificadoExtintores/') === false){
    CrearCarpeta($Dir.'/CertificadoExtintores/');
   
    
   }
   
    $tcpdf->Output($Dir.'/CertificadoExtintores/'.$Nombre.'.pdf', 'F');
    if( $FirmanteInterno != 'Nada' ){
      //$DatosArmador aqui enviamos los datos del certificado
      // actualizamos la fecha de vencimiento  a un ano 
      $this->ExtinguisherModels->GuardarActa($parametros[0],$Nombre);
 $htmlContent = '<h1>Certificado Extintores </h1>';
       if($Email != ""){
        EmailHtml($Email,"SEGMARIND CERTIFICADO", $htmlContent,$Dir.'/CertificadoExtintores/'.$Nombre.'.pdf');

       }
    
       

       

       
        
    }
   
    
    header("Content-type: application/pdf");
    header("Content-Disposition: inline; filename=documento.pdf");
    readfile($Dir.'CertificadoExtintores/'.$Nombre.'.pdf');
   
  
    return;
    
    break;
  }
  */

}
private function Crearpdf($Obj){
  $DatosTienda  = $this->StoreModels->getStore($Obj['Select']['Tienda']['value']);
  $DatosTienda =$DatosTienda[0];
  $Codigo = $Obj['Codigo'];
  $DatosProveedor  = $this->ProviderModels->getProvider($Obj['Text']['Proveedor']['value2']);
  $DatosProveedor = $DatosProveedor[0];
  $Email =   $DatosProveedor->Email;
  if ( $Email === ""){
    return;
  }
  $Proveedor =  $DatosProveedor->Nombre. ' '.$DatosProveedor->Apellido;

  $Token = obtnerToken();
  $Autho = "";
 if($Token != FALSE){
  $Autho =str_replace('Bearer ','', $Token);
 }
 if( $Autho !=""){
  $Autho =str_replace('Bearer ','', $Autho);
  $Token = ValidarToken($Autho);
}
  if(isset($this->session)){
    $ID =  $Token== FALSE ? $this->session->userdata("User") :  $Token ;
}else{
    $ID =   $Token== FALSE ? null :  $Token ;
}
  $User = $this->UserModels->getUser($ID);
  $User=  $User[0];
  $Dire = utf8_encode('Dirección'); 
  $Tele = utf8_encode('Teléfono');
  $Empresa = $DatosTienda->Tienda;
  $Fecha =  date("Y-m-d H:i:s");
  $Cliente = $DatosTienda->Tienda;
  $Direccion =$DatosTienda->$Dire;
  $Telefono = $DatosTienda->$Tele." / " . $User->$Tele;
  $NombreDeContacto = $User->Nombre ." ".  $User->Apellido ;
  $Correo =  $DatosTienda->Correo ." / ".$User->Correo;
  $ArrayProduc = array('Producto','Nombre','Unidades','Cantidad');
  foreach (  $Obj["Articulos"] as $key => $val){
    if($Obj["Articulos"][$key]['Unidades'] === 0){
      $Obj["Articulos"][$key]['Unidades'] = "Unidad";
    }

    $Obj["Articulos"][$key]["Nombre"]= $Obj["Articulos"][$key]["Nombre"].' '. $Obj["Articulos"][$key]["Marca"]. ' '.$Obj["Articulos"][$key]["Modelo"];
  }
  
  $BodyProduc =  $this->BodyTabla($Obj["Articulos"], $ArrayProduc); 
  $tcpdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);

$tcpdf->SetAuthor('segmarind');
$tcpdf->SetTitle('Solicitud al Proveedor');
$tcpdf->SetSubject('segmarind');
$tcpdf->SetKeywords('TCPDF, PDF, segmarind, test, guide');
$tcpdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "", "", array(0,65,256), array(0,65,127));


$tcpdf->setFooterData(array(0,65,0), array(0,65,127));
 
//set header  textual styles
$tcpdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
//set footer textual styles
$tcpdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
 
//set default monospaced textual style
$tcpdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
// set default margins
$tcpdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
// Set Header Margin
$tcpdf->SetHeaderMargin(PDF_MARGIN_HEADER);
// Set Footer Margin
$tcpdf->SetFooterMargin(PDF_MARGIN_FOOTER);
 
// set auto for page breaks
$tcpdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image for scale factor
$tcpdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// it is optional :: set some language-dependent strings
if (@file_exists(dirname(__FILE__).'/lang/eng.php'))
{
// optional
require_once(dirname(__FILE__).'/lang/eng.php');
// optional
$tcpdf->setLanguageArray($l);
}
 
// set default font for subsetting mode
$tcpdf->setFontSubsetting(true);



// Set textual style
// dejavusans is an UTF-8 Unicode textual style, on the off chance that you just need to
// print standard ASCII roasts, you can utilize center text styles like
// helvetica or times to lessen record estimate.
//$tcpdf->SetFont('dejavusans', '', 14, '', true);
 
// Add a new page
// This technique has a few choices, check the source code documentation for more data.
$tcpdf->AddPage();




$set_html = <<<EOD
 
 
<h3  style="text-align: center; text-decoration: underline;">SOLICITUD DE COTIZACIÓN</h3>
<h5  style="text-align: center;">$Empresa </h5>


<br/>
<br/>
<br/>
<br/> 
<div > Nro : $Codigo </div>
<div > Fecha : $Fecha </div>

<div><FONT SIZE="9"  style="text-align: left; display: block;"><b>Datos del solicitante:</b></FONT></div>
<span><FONT SIZE="9"  style="text-align: left; display: block;"><b>Cliente:</b></FONT> $Cliente</span>
<br/>
<span><FONT SIZE="9"  style="text-align: left;"><b>Dirección:</b></FONT> $Direccion</span>
<br/>
<span><FONT SIZE="9"  style="text-align: left;"><b>Teléfono:</b></FONT> $Telefono</span>
<br/>
<span><FONT SIZE="9"  style="text-align: left;"><b>Nombre del contacto:</b></FONT> $NombreDeContacto</span>
<br/>
<span><FONT SIZE="9"  style="text-align: left;"><b>Correo electrónico:</b></FONT> $Correo</span>
<br/>
<div>
<FONT SIZE="9"  > Estimados Señores:  $Proveedor</FONT>
<br/> 
<FONT SIZE="9"  style="text-align: justify;">
Me dirijo a Ustedes con el debido respeto que merece su persona, y expongo que deseo realizar una solicitud de cotización formado por los siguientes productos:</FONT>
</div>

<hr>
<h4  style="text-align: center; ">DESCRIPCIÓN DE PRODUCTOS</h4>
<br/>
<table   border="1" >
<tr>
<th ><FONT SIZE="8"><b>ID</b></FONT></th>
<th ><FONT SIZE="8"><b>Producto</b></FONT></th>
<th ><FONT SIZE="8"><b>Unidades</b></FONT></th>
<th ><FONT SIZE="8"><b>Cantidad</b></FONT></th>
</tr>

$BodyProduc


</table>
<br/>
<br/>


 

<FONT SIZE="9"  style="text-align: justify;">
En caso de no contar con algunos de los artículos o referencias, les rogamos que nos lo comuniquen, y así poder contemplar la posibilidad de sustituirlo por otro similar.</FONT>
<br/>
<br/>
<br/> 
<FONT SIZE="9"  >Sin otro particular, reciban un cordial saludo </FONT>
 
EOD;

//Print content utilizing writeHTMLCell()
$Dir = Raiz();
$tcpdf->writeHTMLCell(0, 0, '', '', $set_html, 0, 1, 0, true, '', true);
if (Existe($Dir.'/Cotizaciones/') === false){
  CrearCarpeta($Dir.'/Cotizaciones/');
 
 }
 $tcpdf->Output($Dir.'/Cotizaciones/'."Cotizacion".'.pdf', 'F');
 if($Email != ""){
  $htmlContent = '<h1>Solicitud de Cotizacion</h1>';
 
  EmailHtml($Email,$Empresa, $htmlContent,$Dir.'/Cotizaciones/'."Cotizacion".'.pdf');

 }

 //$tcpdf->Output('Solicitud.pdf', 'I');
 /*
 switch (count($parametros)) { 
  
  case 0:
    break;
  case 1:
    $tcpdf->Output('Certificado.pdf', 'I');
  break;
  case 2:
  
   if (Existe($Dir.'/CertificadoExtintores/') === false){
    CrearCarpeta($Dir.'/CertificadoExtintores/');
   
    
   }
   
    $tcpdf->Output($Dir.'/CertificadoExtintores/'.$Nombre.'.pdf', 'F');
    if( $FirmanteInterno != 'Nada' ){
      //$DatosArmador aqui enviamos los datos del certificado
      // actualizamos la fecha de vencimiento  a un ano 
      $this->ExtinguisherModels->GuardarActa($parametros[0],$Nombre);
 $htmlContent = '<h1>Certificado Extintores </h1>';
       if($Email != ""){
        EmailHtml($Email,"SEGMARIND CERTIFICADO", $htmlContent,$Dir.'/CertificadoExtintores/'.$Nombre.'.pdf');

       }
    
       

       

       
        
    }
   
    
    header("Content-type: application/pdf");
    header("Content-Disposition: inline; filename=documento.pdf");
    readfile($Dir.'CertificadoExtintores/'.$Nombre.'.pdf');
   
  
    return;
    
    break;
  }
  */

}
private function Add(){
  $Datos = count($_POST) ===0 ? $this->input->raw_input_stream :  $this->input->post();
  if(is_string($Datos) ===true){
    $Datos =  json_decode($Datos, true);
  }

    $Pedidoses= $this->PedidosModels->Add($Datos);
    $Detalle = 9;
  $Obj=  json_decode($Datos[$Detalle], true);



  

  header('Content-type: application/json; charset=utf-8');

  echo json_encode($Pedidoses);
  $Obj['Codigo'] =  $Pedidoses;
  if($Datos[8]===2){
    $this->Crearpdf($Obj);
  }
  if($Datos[8]===3){
    $this->CrearpdfPedido($Obj);
  }
  if($Datos[8]===5 OR $Datos[8]===6 OR $Datos[8]===7 ){
    $this->IngresarProducto($Obj);
  }
  
}
private function IngresarProducto($Obj){
  foreach (  $Obj["Articulos"] as $key => $val){
    
    $Uni =  $this->ObtenerUni($val['Unidades']);
    $Cantidad =intval($val['Cantidad'])* $Uni;
    $Costo = $this->Verificar($val["Costo"]) === false ? 0: intval($val["Costo"]);
    $Proveedor = $Obj['Text']['Proveedor']['value2'];
    $Obs = isset($Obj['Text']['Observación']) ?$Obj['Text']['Observación']['value'] : "Ingreso De Producto";
    $Tienda= $Obj['Select']['Tienda']['value'];
    $Producto=$val["Producto"];
    $Ingreso = "";
    if($this->Verificar($val["vence"])===true){
     
      $Ingreso = '{"Status":0,"Observacion":"'.$Obs.'","Cantidad":"'. $Cantidad.'","CodigoProve":"'.$Proveedor.'","Costo":"'.$Costo.'","Precio":"'.$val["Precio"].'","CodigoMo":"'.$val["Código"].'","Vencimiento": "'. $val["vence"].'", "Tienda" : "'.$Tienda.'", "Producto": "'.$Producto.'" }';
    }else{
      $Ingreso = '{"Status":0,"Observacion":"'.$Obs.'","Cantidad":"'. $Cantidad.'","CodigoProve":"'.$Proveedor.'","Costo":"'.$Costo.'","Precio":"'.$val["Precio"].'","CodigoMo":"'.$val["Código"].'","Vencimiento": "'. "" .'", "Tienda" : "'.$Tienda.'", "Producto": "'.$Producto.'" }';
    }
    $Ingreso= json_decode( $Ingreso, true);
    if($Proveedor === ""){
      $Ingreso['CodigoProve'] = null;
       }
       $Ingreso= $this->WarehouseModels->Add($Ingreso);
  }
  return;

}
private function ObtenerUni($Dato = 0 ){
  $Uni = 1;
  if ($Dato === 0){
    $Uni = 1;
  }else{
    if ($Dato === "Unidad"){
      $Uni = 1;
    }else{
     $arr1 = explode(":",$Dato);
     if(count($arr1)>1 ){
      $dato = $arr1[count($arr1) -1];
      $Uni = intval($dato);
      if ($Uni <1){
        $Uni = 1;
      }
     }else{
      $Uni = 1;
     }

    }
  }
  return $Uni;
}
private function Verificar($dato = null){
  //isset()
  if($dato=== null OR $dato === ""  ){
    return false;
  }
  return true;
  
}
     
private function Edit(){
  $Datos = $this->input->raw_input_stream;
  if(is_string($Datos) ===true){
    $Datos =  json_decode($Datos, true);
  }
  $Pedidoses= $this->PedidosModels->Edit($Datos);
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Pedidoses);
  $Detalle = 9;
  $Obj=  json_decode($Datos[$Detalle], true);
  if($Datos[8]===4){
    $Obj['Codigo'] = $Datos[0];
    $this->CrearpdfPedido($Obj);
  }
  if($Datos[8]===5 OR $Datos[8]===6 OR $Datos[8]===7 ){
    $this->IngresarProducto($Obj);
  }
    
}

private function Delete($ID ){
  $Pedidoses= $this->PedidosModels->Delete($ID[0]);
  header('Content-type: application/json; charset=utf-8');
  echo json_encode($Pedidoses);
}

// aqui viene los metodos de buscar



private function Search($Arr =array() ){
  $Pedidoses =array();
  switch (count($Arr)) 
  { case 0:
    $Pedidoses= $this->PedidosModels->getPedidos();
    break;
    case 1: 
      $Pedidoses = $this->PedidosModels->getPedidos($Arr[0]);
    break;
    case 2: 
      $Pedidoses = $this->PedidosModels->getPedidosLimite($Arr[0],$Arr[1]);
    break; 
    case 4: 
      $Pedidoses = $this->PedidosModels->getPedidosLimiteOrden($Arr[0],$Arr[1],$Arr[2],$Arr[3]);
    break; 
    case 5: 
      $Pedidoses = $this->PedidosModels->getPedidosLimiteOrdenColumnas($Arr[0],$Arr[1],$Arr[2],$Arr[3],urldecode($Arr[4]));
   break; 
   default: 
   return json_encode( "Error" );
   break; 
  }
  header('Content-type: application/json; charset=utf-8');
  return  json_encode($Pedidoses); 
}

private function Buscar1 ($Arr = array()){
  $Pedidoses =array();
  switch (count($Arr)) 
  {
    case 1: 
      $Pedidoses = $this->PedidosModels->getPedidosFiltro(urldecode($Arr[0]));
    break;
    case 3: 
      $Pedidoses = $this->PedidosModels->getPedidosFiltroLimite(urldecode($Arr[0]),$Arr[1],$Arr[2]);
    break; 
    case 5: 
      $Pedidoses = $this->PedidosModels->getPedidosFiltroLimiteOrden(urldecode($Arr[0]),$Arr[1],$Arr[2],$Arr[3],$Arr[4]);
   break; 
   case 6: 
    $Pedidoses = $this->PedidosModels->getPedidosFiltroLimiteOrdenColumnas(urldecode($Arr[0]),$Arr[1],$Arr[2],$Arr[3],$Arr[4],urldecode($Arr[5]));
    break; 
   default: 
   return json_encode( $Arr );
   break; 
  }
  header('Content-type: application/json; charset=utf-8');
  return json_encode($Pedidoses); 
  
}
private function Buscar2 ($Arr =array()){
  $Pedidoses =array();
  $Pedidoses = $this->PedidosModels->getPedidosFiltroColumnas(urldecode($Arr[0]),urldecode($Arr[1]));
  header('Content-type: application/json; charset=utf-8');
  return json_encode($Pedidoses); 
}

private function Buscar3 ($Arr =array()){
  $Pedidoses =array();
    $Pedidoses= $this->PedidosModels->  getPedidosIdColum($Arr[0],urldecode($Arr[1]));
  header('Content-type: application/json; charset=utf-8');
  return json_encode($Pedidoses); 
}
private function Buscar4 ($Arr = array()){
  $Pedidoses =array();
    $Pedidoses= $this->PedidosModels->getPedidosLimiteColum($Arr[0],$Arr[1],urldecode($Arr[2]));
  header('Content-type: application/json; charset=utf-8');
  return json_encode($Pedidoses); 
}
private function Buscar5 ($Arr =  array()){
  $Pedidoses =array();
  $Pedidoses = $this->PedidosModels->getPedidosFiltroLimitesColumnas(urldecode($Arr[0]),$Arr[1],$Arr[2],urldecode($Arr[3]));
  header('Content-type: application/json; charset=utf-8');
  return json_encode($Pedidoses); 

}

private function Pdf(){

  $Pedidoses= $this->PedidosModels->getPedidos();
  $Pedidoses = str_replace('C\u00c3\u00b3digo','Codigo',json_encode($Pedidoses));
  $Pedidoses = str_replace('Tel\u00c3\u00a9fono','Telefono',$Pedidoses);
  $Pedidoses = str_replace('Direcci\u00c3\u00b3n','Direccion',$Pedidoses);
  $Pedidoses= json_decode($Pedidoses);
 $bodytPedidoses= $this->BodyTabla($Pedidoses,array('Codigo','Rut',"Nombre","Apellidos",'Telefono','Direccion',"Comuna"));
 //echo json_encode($Pedidoses);
// return;
  $tcpdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
  $tcpdf->SetAuthor('segmarind');
  $tcpdf->SetTitle('Reporte de Pedidoses');
  $tcpdf->SetSubject('segmarind');
  $tcpdf->SetKeywords('TCPDF, PDF, segmarind, test, guide');
  $tcpdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "", "", array(0,65,256), array(0,65,127));
  $tcpdf->setFooterData(array(0,65,0), array(0,65,127));
  $tcpdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
  $tcpdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
  $tcpdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
  $tcpdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
  $tcpdf->SetHeaderMargin(PDF_MARGIN_HEADER);
  $tcpdf->SetFooterMargin(PDF_MARGIN_FOOTER);
  $tcpdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
  $tcpdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
if (@file_exists(dirname(__FILE__).'/lang/eng.php'))
{
// optional
require_once(dirname(__FILE__).'/lang/eng.php');
// optional
$tcpdf->setLanguageArray($l);
}
 
$tcpdf->setFontSubsetting(true);
$tcpdf->AddPage();
$set_html = <<<EOD
 
 

<h3  style="text-align: center;">Reporte De Pedidoses</h3>

<br/>

<br>
<br/>
<br/>

<br>
<br>



<table   border="1" >

<tr>
<th ><FONT SIZE="8"><b> Código</b></FONT></th>
<th ><FONT SIZE="8"><b> Rut</b></FONT></th>
<th ><FONT SIZE="8"><b> Nombre</b></FONT></th>
<th ><FONT SIZE="8"><b> Apellidos </b></FONT></th>
<th ><FONT SIZE="8"><b> Teléfono</b></FONT></th>
<th ><FONT SIZE="8"><b> Dirección</b></FONT></th>
<th ><FONT SIZE="8"><b> Comuna</b></FONT></th>
</tr>
$bodytPedidoses
</table> 
EOD;
$tcpdf->writeHTMLCell(0, 0, '', '', $set_html, 0, 1, 0, true, '', true);
$tcpdf->Output('tcpdfexample-onlinecode.pdf', 'I');
  return;
}


function BodyTabla($arr,$Titulos){
 
  $Fi = "";
  foreach ($arr as $Fila){
    $Fi=  $Fi.'<tr>';
    $Colum= '';
 
    
         for( $i=0; $i< count($Titulos); $i++  ){
          foreach (  $Fila as $key => $val){
          if( $Titulos[$i] ===$key){
            $Colum =  $Colum. '<td ><FONT SIZE="8"> '. $val.' </FONT></td>';
          }
        }
        }
    
    $Fi= $Fi.$Colum.'</tr>';
  }
return $Fi;


}

private function MetaData(){
  $Pedidoses =array();
  $Pedidoses = $this->PedidosModels->MetaData();
  header('Content-type: application/json; charset=utf-8');
  return  json_encode($Pedidoses); 
}

    protected function middleware()
    {
      return ['Sesion'];
    }

	
}